////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBFileSaveDialog.h
//		Definition of the parent class that allows a single call to Save files through the respective platform's Dialog or Panel.
//
//  Copyright (C) 2011 Acclivity Group LLC. All rights reserved.
//
//  Change History (most recent first):
//
//  11/17/11  G.R.W.  Added static method to be used as a substitute for ALL PutFile and CallCommonSaveReplacement calls.
//  05/18/11  G.R.W.  Rewrite to include setters/getters
//  04/26/11  G.R.W.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"
#include "ObsoleteBridge/OBFileDialog.h"

namespace ObsoleteBridge
{
	class EXTERNAL_API OBFileSaveDialog  : public ObsoleteBridge::OBFileDialog
	{
	public:
		static OBFileSaveDialog* Create(void);

		static CPString AskForPath(void);
		static CPString AskForPathWithMessage(const CPString& Message);
		static CPString AskForPathWithMessageAllowingFileType(const CPString& Message, const CPString& AllowedFileType);
		static CPString AskForPathWithMessageAllowingFileTypes(const CPString& Message, const CPArray& AllowedFileTypes);
        static CPString AskForPathWithMessageAndFilePath(const CPString& Message, const CPString& FilePath);
		static CPString AskForPathWithMessageAndFilePathAllowingFileType(const CPString& Message, const CPString& FilePath,
																		 const CPString& AllowedFileType);
		static CPString AskForPathWithMessageAndFilePathAllowingFileTypes(const CPString& Message, const CPString& FilePath,
																		  const CPArray& AllowedFileTypes);

		virtual void SetPromptUserOnOverwrite(bool ShouldPromptOnOverWrite);

		virtual ~OBFileSaveDialog(void);

		virtual CPString ShowSaveDialog(void) = 0;

	protected:
		OBFileSaveDialog(void);
	};
}
